import { Component, Output, EventEmitter, OnInit } from '@angular/core';
import { AthleteService } from './athlete.service';
import { Athlete } from "./athlete";
import { Observable } from "rxjs/Observable";


@Component({
  selector: 'app-athlete-list',
  templateUrl:'athlete-list.component.html'
})
export class AthleteListComponent implements OnInit {
  athletes: Athlete[];
  @Output() selected = new EventEmitter<Athlete>();
  constructor(private athleteService: AthleteService){  }

  getAthletes() {
    this.athleteService.getAthletes()
    .then(list => this.athletes=list);
  } 

  ngOnInit(){this.getAthletes();}

  select(selectedAthlete: Athlete){
    this.selected.emit(selectedAthlete);
  }
}